/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPAddress;
import apicore.message.IPCEventLTV;
import apicore.message.MACAddress;
import apiipc.ipc.IPCEvent;

public abstract class ARPProcessEvent
extends IPCEvent {
    public EventType type;

    public ARPProcessEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ARP_ENTRY_ADDED,
        ARP_ENTRY_REMOVED,
        FOUND_TAKING_MY_IP,
        FOUND_MY_IP_TAKEN;

    }

    public static class FoundMyIpTaken
    extends ARPProcessEvent {
        public IPAddress ip;
        public MACAddress otherMac;
        public String portName;

        public FoundMyIpTaken(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.FOUND_MY_IP_TAKEN;
            this.ip = (IPAddress)iPCEventLTV.getEventParameters().get(0);
            this.otherMac = (MACAddress)iPCEventLTV.getEventParameters().get(1);
            this.portName = (String)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tip = " + this.ip + "\n\totherMac = " + this.otherMac + "\n\tportName = " + this.portName;
        }
    }

    public static class FoundTakingMyIp
    extends ARPProcessEvent {
        public IPAddress ip;
        public MACAddress otherMac;
        public String portName;

        public FoundTakingMyIp(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.FOUND_TAKING_MY_IP;
            this.ip = (IPAddress)iPCEventLTV.getEventParameters().get(0);
            this.otherMac = (MACAddress)iPCEventLTV.getEventParameters().get(1);
            this.portName = (String)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tip = " + this.ip + "\n\totherMac = " + this.otherMac + "\n\tportName = " + this.portName;
        }
    }

    public static class ArpEntryRemoved
    extends ARPProcessEvent {
        public IPAddress ip;
        public MACAddress mac;
        public String portName;

        public ArpEntryRemoved(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.ARP_ENTRY_REMOVED;
            this.ip = (IPAddress)iPCEventLTV.getEventParameters().get(0);
            this.mac = (MACAddress)iPCEventLTV.getEventParameters().get(1);
            this.portName = (String)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tip = " + this.ip + "\n\tmac = " + this.mac + "\n\tportName = " + this.portName;
        }
    }

    public static class ArpEntryAdded
    extends ARPProcessEvent {
        public IPAddress ip;
        public MACAddress mac;
        public String portName;

        public ArpEntryAdded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.ARP_ENTRY_ADDED;
            this.ip = (IPAddress)iPCEventLTV.getEventParameters().get(0);
            this.mac = (MACAddress)iPCEventLTV.getEventParameters().get(1);
            this.portName = (String)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tip = " + this.ip + "\n\tmac = " + this.mac + "\n\tportName = " + this.portName;
        }
    }
}

